/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowMaster;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIMate;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetMaster;
import com.lycanitesmobs.core.entity.ai.EntityAITargetMasterAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.desertmobs.entity.EntityJoustAlpha;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityJoust
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal {
    public EntityJoust(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = true;
        this.babySpawnChance = 0.1;
        this.canGrow = true;
        this.setWidth = 0.9f;
        this.setHeight = 2.2f;
        this.attackTime = 10;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt(this).setItemList("CactusFood"));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setRate(10).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowMaster(this).setSpeed(1.0).setStrayDistance(8.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityJoustAlpha.class));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetMasterAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetMaster(this).setTargetClass(EntityJoustAlpha.class).setSightCheck(false).setRange(64.0));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 10.0);
        baseAttributes.put("movementSpeed", 0.32);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("JoustMeatRaw")), 1.0f).setBurningDrop(new ItemStack(ObjectManager.getItem("JoustMeatCooked"))).setMaxAmount(3));
    }

    @Override
    public void onFirstSpawn() {
        MobInfo alphaInfo = ObjectManager.getMobInfo("joustalpha");
        if (alphaInfo != null) {
            float alphaChance = (float)alphaInfo.spawnInfo.spawnWeight / (float)Math.max(this.mobInfo.spawnInfo.spawnWeight, 1);
            if (this.func_70681_au().nextFloat() <= alphaChance) {
                EntityJoustAlpha alpha = new EntityJoustAlpha(this.func_130014_f_());
                alpha.func_82149_j((Entity)this);
                this.func_130014_f_().func_72838_d((Entity)alpha);
                this.func_130014_f_().func_72900_e((Entity)this);
            }
        }
        super.onFirstSpawn();
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return 7.0f;
            }
            if (blockState.func_185904_a() == Material.field_151576_e) {
                return 5.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        if (!this.hasAttackTarget() && !this.hasMaster()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityJoustAlpha.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76438_s) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return new EntityJoust(this.field_70170_p);
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("cactusfood", testStack);
    }

    @Override
    public void setGrowingAge(int age) {
        if (age == 0 && this.func_70654_ax() < 0 && this.func_70681_au().nextFloat() >= 0.9f) {
            EntityJoustAlpha alphaJoust = new EntityJoustAlpha(this.field_70170_p);
            alphaJoust.func_82149_j((Entity)this);
            this.field_70170_p.func_72838_d((Entity)alphaJoust);
            this.field_70170_p.func_72900_e((Entity)this);
        }
        super.setGrowingAge(age);
    }
}

